open Listc
open Format
open List

(* type of modal formulas *)

type formula =
  | False 
  | Var of string
  | Or of formula * formula
  | And of formula * formula
  | Equ of formula * formula
  | Imp of formula * formula
  | Not of formula
  | Pos of formula
  | Nec of formula
;;



let print_formula a = 
  let rec prec_formula a =
	match a with
	  | False -> print_string "F"
	  | (Var x) -> print_string x
	  | (Not a) -> print_string "-"; prec_formula a
	  | (Nec a) -> print_string "[]";  prec_formula a
	  | (Pos a) -> print_string "<>"; prec_formula a
	  | (And (a,b)) -> print_char '(';
	      prec_formula a; print_space () ;print_string ".";
	      print_space (); prec_formula b;
	      print_char ')'
	  | (Or (a,b)) ->  print_char '(';
	      prec_formula a; print_space (); print_string "+";
	      print_space(); prec_formula b;
	      print_char ')'
	  | (Imp (a,b)) ->  print_char '(';
	      prec_formula a;  print_space (); print_string "=>";
	      print_space (); prec_formula b;
	      print_char ')'
	  | (Equ (a,b)) ->  print_char '(';
	      prec_formula a;  print_space (); print_string "<=>";
	      print_space (); prec_formula b;
	      print_char ')'

  in 
    (open_hvbox 2; prec_formula a ; close_box (); print_flush());;




(* Modèles GL : arbres finis dont chaque sommet porte un entier l'état du sommet
et la liste des variables que cet état satisfait *)

type model =
{
   state : int;
   valuation : formula list;
   successor : model list};;



let print_valuation s la =
   (* s est un entier, la est la liste de variables vraies dans cet état
   *)
   if la = [] then (print_string "No variables is true in the state ";
   print_int s)
   else 
   (* On remplace la par une liste où chaque variable ne figure qu'une fois *)
   let la = suppress_multi_occurrence la in
   (print_string "The true variables in state ";print_int s; 
    print_string " are : ";
    (let Var x = List.hd la in 
       print_string x;
       List.iter (fun (Var x) -> print_string ", ";print_string x)
		      (List.tl la)))
;;
   

let rec print_model a = 
  (* pour chaque état du modèle, affiche les variables vraies dans cet état *)
  print_valuation a.state a.valuation;
  print_newline ();
  List.iter (fun x -> print_model x) a.successor;;



let rec print_aux_relation a = 
  (* affiche la relation du modèle a, quand cette relation n'est pas vide *)
    if a.successor <> [] then
    (print_int a.state;print_string " -> "; 
    print_int (List.hd a.successor).state;
    List.iter (function x -> print_string " , "; print_int x.state) 
			(List.tl a.successor);
    print_newline ();
    List.iter (fun x -> print_aux_relation x) a.successor);;
   
   
  let print_relation a =
  (* affiche la relation du modèle a *)
  if a.successor = [] then
  (print_string "The accessibility relation is empty";
   print_newline ();)
  else
  (print_string "the accessiblity relation is the transitive closure of";
   print_newline ();print_string "the following relation :";
   print_newline ();
   print_aux_relation a);;

(* représentation des séquents 
Un sequent comporte 6 listes de formules.
Pour l'antécédent et le succédent du séquent, il y a la liste des variables, 
la liste des formules nécessaires et 
la liste des formules à traiter.
Quand on a essayé de prouver un séquent, la tentative de preuve nous donne comme résultat, 
une preuve, qui est un arbre de séquents ou un contre-modèle du séquent.
*)

type sequent = {left_atoms : formula list; left_necessary : formula list;
  left_todo : formula list;
  right_atoms : formula list ; right_necessary : formula list; 
  right_todo : formula list};;


type rule = OrLeft | OrRight | AndLeft | AndRight | ImplyLeft | ImplyRight |
    EquivLeft | EquivRight | NotLeft | NotRight | NecRight | PosLeft| PosRight | 
    Initial | ExchangeWidening | None ;;

let print_rule r = match r with
   OrLeft ->   "orL    "
|  OrRight ->  "orR    "
|  AndLeft ->  "andL   "
|  AndRight -> "andR   "
|  ImplyLeft ->"implyL "
|  ImplyRight->"implyR "
|  EquivLeft ->"equivL "
|  EquivRight->"equivR "
|  NotLeft  -> "notR   "
|  NotRight -> "notL   "
|  NecRight -> "necR   "
|  PosLeft ->  "posL   "
|  PosRight -> "posR   "
|  Initial ->  "initial"
;;

type proof = {root : sequent; premisses : proof list ; used_rule : rule };;

type numbered_proof = {num : int; antecedent : formula list; succedent : formula list;
        nbpremisses : numbered_proof list ; nbused_rule : rule};;
(* Une preuve est initialement une arbre de type proof, elle est transformée en deux temps.
   Tout d'abord les séquents sont numérotés dans l'ordre postfixé de l'arbre (racine en dernier),
   la preuve est donnée, sans les règles structurelles.
   Puis l'affichage proprement dit est faite *)

let rec print_proof p =
(* parcours postfixé de la preuve numérotée p, chaque ligne d'une preuve est terminée par un retour à la ligne *)
   List.iter print_proof  p.nbpremisses;
   print_int p.num;print_string " : "; 
   (* affiche de l'antécédent du séquent *)
   if p.antecedent <> [] then
   (print_formula (hd p.antecedent); List.iter (fun x -> print_string ", "; print_formula x) (tl p.antecedent));
   print_string "  |--  ";
   if p.succedent <> [] then 
   (print_formula (hd p.succedent); List.iter (fun x -> print_string ", "; print_formula x) (tl p.succedent));
   (* affichage de la règle *)
   if p.nbpremisses = []
   then print_string ("   "^"initial sequent")
   else
   begin
     print_string "  by ";  print_string (print_rule p.nbused_rule); 
     print_string " applied to ";
     print_int (hd p.nbpremisses).num;
     List.iter (fun x -> print_string ", ";print_int x.num) (tl (p.nbpremisses))
   end;
   print_newline ();;

   
   

let rec transform_proof n pr =
  (* si le résultat est (p,prp) alors les séquents sont numérotés de n à p inclus *)
  if pr.used_rule = ExchangeWidening
  then (* ignorer cette règle *) let [pr1]=pr.premisses in transform_proof n pr1
  else let seq = pr.root in 
       let p, proof_list = transform_proof_list n pr.premisses in
       p+1, {num = p+1;antecedent= seq.left_todo @  seq.left_necessary @ seq.left_atoms;
       succedent = seq.right_todo @ seq.right_necessary @ seq.right_atoms;nbpremisses=proof_list;
       nbused_rule = pr.used_rule}
and transform_proof_list n prlist =
(* si le résultat est (p, lprp) alors les séquents sont numérotée de n à p inclus *)
match prlist with
| [] -> n-1, []
| pr::lpr ->
let p,prp = transform_proof n pr in
let q,prplist = transform_proof_list (p+1) lpr in q, prp::prplist
;;

(* Affichage des preuves : le numero du séquent est affiché suivi de deux points suivi de l'antécédent
   du séquent, suivi de |-, suivi du succédent et d'un retour à la ligne. Puis on a la règle appliquée. *)



   

type sequent_model = {sequent_state : sequent ; sequent_successor : sequent_model list};;

(* le type de modèle ci-dessus est celui de svejdar : ses états sont des pointeurs vers des
   séquents critiques. Il est traduit ci-dessous en un modèle dont les états 
sont des entiers *)

let rec transform_sequent n a = 
   let p, model_list = transform_sequent_list (n+1) a.sequent_successor in
   p, {state = n; valuation = a.sequent_state.left_atoms; successor = model_list }
and transform_sequent_list n al = 
   match al with
   | [] -> n, []
   | x::l -> 
    let p,y = transform_sequent n x in
    let q,ly = transform_sequent_list p l in
     q, y::ly
  ;;
    





  

















