<?php $title="LK-GL rules"; include ("header.inc"); ?>

The rules used by the prover are the rules of the Gentzen sequent calculus LK completed by the following rule,
which is named <font color = red>necR</font> (necessary right) in the prover
<table border cellpadding="8" cellspacing="4">
<tr>
<td>
<pre>
[]&Gamma;, &Gamma;,[]A |-- A
------------------(<font color=red>necR</font>)
[]&Gamma; |-- []A
</pre>
</td>
</table>
where A is a formula, &Gamma; is a formula's list, []&Gamma; is the list obtained by
adding the sign [] in front of each element of &Gamma;, the sign
|-- separates the antecedent list and the succedent list of a sequent.
<br>
When we're trying to find a proof, this rule is applied backwards to  the critical sequents of the form
&Lambda;, []&Gamma; |--&Pi;,[]&Delta; where  &Gamma; and &Delta; are formula's list, &Lambda; and &Pi;
are variables list. This backwards
application is actually the below combination of the <font color = red>necR</font> rule and weakening rules
<table border cellpadding="8" cellspacing="4">
<tr>
<td>
<pre>
[]&Gamma;, &Gamma;,[]A |-- A
-------------------- where A is member of list &Delta;
&Lambda;, []&Gamma; |-- &Pi;, []&Delta;
</pre>
</td>
</table>
We give below, as examples, only four of the propositionnal LK rules, <font color=red>implyL</font>,
<font color=red>orL</font> with two premisses and
<font color=red>implyR</font>, <font color=red>orR</font>  with one premisse. 
<table border cellpadding="8" cellspacing="4">
<tr>
<td>
<pre>
 &Gamma; |-- A, &Delta;      B, &Gamma; |-- &Delta;
 ---------------------------(<font color =red>implyL</font>)
 A => B, &Gamma; |-- &Delta;
</pre>
</td>
<td>
<pre>
A, &Gamma; |-- B, &Delta;
----------------- (<font color = red>implyR</font>)
&Gamma; |-- A => B, &Delta;
</pre>
</td>
<td>
<pre>
  A, &Gamma; |-- &Delta;    B, &Gamma; |-- &Delta;
  -------------------------(<font color=red>orL</font>)
  A+B, &Gamma; |-- &Delta;
</pre>
</td>
<td>
<pre>
 &Gamma; |-- A, B, &Delta;
 --------------(<font color=red>orR</font>)
 &Gamma; |-- A+B, &Delta;
</pre>
</td>
</table>








<?php include("footer.inc"); ?>