(* Voici le programme principal effectuant la preuve des séquents *)

open Structure;;
open List;;

let empty_sequent =
   {left_atoms=[];left_necessary=[];left_todo=[];right_atoms=[];right_necessary=[];
right_todo=[]};;

let empty_proof =
  {root = empty_sequent;premisses = [];used_rule = None}

type result_try_proof = Success of proof | CounterModel of sequent_model;;

(* un séquent initial est défini par svejdar, c'est un séquent avec une même formule
dans l'antécédent et le succédent ou la formule False dans l'antécédent *)

let initial s = let antecedent = s.left_atoms @ s.left_necessary @ s.left_todo and
succedent = s.right_atoms @ s.right_necessary  @ s.right_todo in 
(exists (fun x -> mem x succedent) antecedent) || (mem False antecedent);;

let rec try_proof s =
(* s est de type sequent et la tentative de preuve donne soit une preuve , soit un
   (contre) modèle de s *)
if initial s then Success {root = s; premisses = []; used_rule =Initial}
else 
if s.left_todo <> [] then 
(* règles propositionnelles gauches *)
(let phi = hd (s.left_todo) and nlt = tl (s.left_todo) in
match phi with
| Var _ | False ->
    (let ns = {left_atoms = phi:: s.left_atoms; left_necessary = s.left_necessary;
    left_todo = nlt; right_atoms = s.right_atoms; right_necessary = s.right_necessary;
    right_todo = s.right_todo} in
    let pc = try_proof ns
     in
    match pc with
    | CounterModel _ -> pc 
    | Success pr -> Success {root =s; premisses = [pr]; used_rule = ExchangeWidening})
| Nec _ ->
    (let ns = {left_atoms = s.left_atoms; left_necessary = phi::s.left_necessary;
    left_todo = nlt; right_atoms = s.right_atoms; right_necessary = s.right_necessary;
    right_todo = s.right_todo} in
    let pc = try_proof ns
     in
    match pc with
    | CounterModel _ -> pc 
    | Success pr -> Success {root =s; premisses = [pr]; used_rule = ExchangeWidening})
| Not a ->
    (let ns = {left_atoms = s.left_atoms; left_necessary = s.left_necessary;
    left_todo = nlt; right_atoms = s.right_atoms; right_necessary = s.right_necessary;
    right_todo = a::s.right_todo} in
    let pc = try_proof ns
     in
    match pc with
    | CounterModel _ -> pc 
    | Success pr -> Success {root =s; premisses = [pr]; used_rule = NotLeft})
| Imp (a,b) ->
    (let ns1 = {left_atoms = s.left_atoms; left_necessary = s.left_necessary;
    left_todo = nlt; right_atoms = s.right_atoms; right_necessary = s.right_necessary;
    right_todo = a::s.right_todo} in
    let pc1 = try_proof ns1 in
    match pc1 with
    | CounterModel _ -> pc1 
    | Success pr1 ->
       let ns2 = {left_atoms = s.left_atoms; left_necessary = s.left_necessary;
       left_todo = b::nlt; right_atoms = s.right_atoms; right_necessary = s.right_necessary;
       right_todo = s.right_todo} in
        let pc2 = try_proof ns2 in
      match pc2 with
      | CounterModel _ -> pc2
      | Success pr2 -> 
        Success {root =s;premisses=[pr1;pr2];used_rule = ImplyLeft})
| And (a,b) ->
     (let ns ={left_atoms = s.left_atoms; left_necessary=s.left_necessary;
      left_todo = a::(b::nlt);right_atoms=s.right_atoms;right_necessary=s.right_necessary;
      right_todo=s.right_todo}in
      let pc = try_proof ns in
      match pc with
      | CounterModel _ -> pc
      | Success pr -> Success {root = s ;premisses = [pr];used_rule = AndLeft})
| Equ (a,b) ->
      (let ns ={left_atoms = s.left_atoms;left_necessary=s.left_necessary;
       left_todo= Imp (a,b)::(Imp(b,a)::nlt); right_atoms=s.right_atoms;right_necessary=s.right_necessary;
        right_todo=s.right_todo}in
      let pc = try_proof ns in
      match pc with
      | CounterModel _ -> pc
      | Success pr -> Success {root = s ;premisses = [pr];used_rule = EquivLeft})
| Or (a,b) ->
    (let ns1 = {left_atoms = s.left_atoms;left_necessary = s.left_necessary;
     left_todo = a::nlt; right_atoms = s.right_atoms; right_necessary = s.right_necessary;
     right_todo=s.right_todo} in
     let pc1 = try_proof ns1 in
     match pc1 with
     | CounterModel _ -> pc1
     | Success pr1 ->
       let ns2 = {left_atoms = s.left_atoms;left_necessary= s.left_necessary;
       left_todo=b::nlt; right_atoms = s.right_atoms; right_necessary = s.right_necessary;
       right_todo = s.right_todo} in
       let pc2 = try_proof ns2 in
       match pc2 with
       | CounterModel _ -> pc2
       | Success pr2 ->
         Success {root = s; premisses=[pr1;pr2];used_rule = OrLeft})
| Pos a ->
    (let ns = {left_atoms = s.left_atoms; left_necessary = s.left_necessary;
     left_todo = nlt; right_atoms = s.right_atoms; right_necessary = (Nec (Not a))::s.right_necessary;
     right_todo =s.right_todo} in
     let pc = try_proof ns in
     match pc with
     | CounterModel _ -> pc
     | Success pr -> Success{root = s;premisses = [pr];used_rule = PosLeft}))



(* Pour l'instant on ne met pas les règles de l'équivalence  *)
else if  s.right_todo <> [] then 
(* règles propositionnelles droites *)
(let phi = hd (s.right_todo) and nlt = tl (s.right_todo) in
match phi with
| False ->
    (let ns = {left_atoms = s.left_atoms; left_necessary = s.left_necessary;
    left_todo = s.left_todo; right_atoms = s.right_atoms; right_necessary = s.right_necessary;
    right_todo = nlt} in
    let pc = try_proof ns
     in
    match pc with
    | CounterModel _ -> pc 
    | Success pr -> Success {root =s; premisses = [pr]; used_rule = ExchangeWidening})
   
| Var _ ->
    (let ns = {left_atoms = s.left_atoms; left_necessary = s.left_necessary;
    left_todo = s.left_todo; right_atoms = phi::s.right_atoms; right_necessary = s.right_necessary;
    right_todo = nlt} in
    let pc = try_proof ns
     in
    match pc with
    | CounterModel _ -> pc 
    | Success pr -> Success {root =s; premisses = [pr]; used_rule = ExchangeWidening})
| Nec _ ->
    (let ns = {left_atoms = s.left_atoms; left_necessary = s.left_necessary;
    left_todo = s.left_todo; right_atoms = s.right_atoms; right_necessary = phi::s.right_necessary;
    right_todo = nlt} in
    let pc = try_proof ns
     in
    match pc with
    | CounterModel _ -> pc 
    | Success pr -> Success {root =s; premisses = [pr]; used_rule = ExchangeWidening})
| Not a ->
    (let ns = {left_atoms = s.left_atoms; left_necessary = s.left_necessary;
    left_todo = a::s.left_todo ; right_atoms = s.right_atoms; right_necessary = s.right_necessary;
    right_todo = nlt} in
    let pc = try_proof ns in
    match pc with
    | CounterModel _ -> pc 
    | Success pr -> Success {root =s; premisses = [pr]; used_rule = NotRight})
| Imp (a,b) ->
   (let ns = {left_atoms = s.left_atoms; left_necessary = s.left_necessary;
    left_todo = a::s.left_todo; right_atoms = s.right_atoms; right_necessary = s.right_necessary;
    right_todo = b::nlt} in
    let pc = try_proof ns in 
    match pc with
    | CounterModel _ -> pc
    | Success pr -> Success {root =s; premisses = [pr]; used_rule = ImplyRight})
| And (a,b) ->
    (let ns1 = {left_atoms = s.left_atoms; left_necessary = s.left_necessary;
    left_todo = s.left_todo; right_atoms = s.right_atoms; right_necessary = s.right_necessary;
    right_todo = a::nlt} in
    let pc1 = try_proof ns1 in
    match pc1 with
    | CounterModel _ -> pc1 
    | Success pr1 ->
       let ns2 = {left_atoms = s.left_atoms; left_necessary = s.left_necessary;
       left_todo = s.left_todo; right_atoms = s.right_atoms; right_necessary = s.right_necessary;
       right_todo = b::nlt} in
        let pc2 = try_proof ns2 in
      match pc2 with
      | CounterModel _ -> pc2
      | Success pr2 -> 
      Success {root =s;premisses=[pr1;pr2];used_rule = AndRight})
| Equ (a,b) ->
    (let ns1 = {left_atoms = s.left_atoms; left_necessary = s.left_necessary;
    left_todo = s.left_todo; right_atoms = s.right_atoms; right_necessary = s.right_necessary;
    right_todo = Imp(a,b)::nlt} in
    let pc1 = try_proof ns1 in
    match pc1 with
    | CounterModel _ -> pc1 
    | Success pr1 ->
       let ns2 = {left_atoms = s.left_atoms; left_necessary = s.left_necessary;
       left_todo = s.left_todo; right_atoms = s.right_atoms; right_necessary = s.right_necessary;
       right_todo = Imp(b,a)::nlt} in
        let pc2 = try_proof ns2 in
      match pc2 with
      | CounterModel _ -> pc2
      | Success pr2 -> 
      Success {root =s;premisses=[pr1;pr2];used_rule = EquivRight})



| Or (a,b) ->
     (let ns ={left_atoms = s.left_atoms; left_necessary=s.left_necessary;
      left_todo = s.left_todo ;right_atoms=s.right_atoms;right_necessary=s.right_necessary;
      right_todo=a::b::nlt}in
      let pc = try_proof ns
      in
      match pc with
      | CounterModel _ -> pc
      | Success pr -> Success {root = s ;premisses = [pr];used_rule = OrRight})
| Pos a ->
    (let ns = {left_atoms = s.left_atoms; left_necessary = (Nec (Not a))::s.left_necessary;
     left_todo = s.left_todo ; right_atoms = s.right_atoms; right_necessary = s.right_necessary;
     right_todo = nlt} in
     let pc = try_proof ns in
     match pc with
     | CounterModel _ -> pc
     | Success pr -> Success{root = s;premisses = [pr];used_rule = PosRight}))

else 
(* On essaie de voir si un des sequents d'antécédent 
s.left_necessary et de succédent (Nec a) où (Nec a) est une formule de s.right_necessary est
prouvable par la règle NecRight 
Rappelons que un tel séquent []gamma => []a a comme prémisse 
[]gamma,gamma,[]a => a
Dans le programme ci-dessous, []gamma est noté ngamma, []a est noté na
*)
begin
  let lnr = ref s.right_necessary in
  let lm = ref [] in
  let ngamma = s.left_necessary in
  let gamma = List.map (function (Nec a) -> a) ngamma in 
  let proof_done = ref false and proof = ref empty_proof in
  while not !proof_done && (!lnr <> []) do
    let na = hd !lnr in
    let (Nec a) = na in
    let ns = {left_atoms =[];left_necessary =na::ngamma;left_todo=gamma;
      right_atoms =[];right_necessary=[];right_todo=[a]} in
    let pc = try_proof ns in
    match pc with
    | CounterModel m -> lm:= m::!lm; lnr := tl (!lnr)
    | Success pr -> proof_done := true; proof := {root = s;premisses=[pr];used_rule=NecRight}
  done;
  if !proof_done then
  Success !proof
  else
  CounterModel{sequent_state=s;sequent_successor = !lm}
end
;;
    
   

let try_proof_formula a = 
let pc = 
try_proof {left_atoms = [];left_necessary = [];left_todo=[]; right_atoms =[];
right_necessary = []; right_todo = [a]} in
match pc with 
| CounterModel m -> print_string "The formula is false in state 1 of the model below :";
     print_newline ();
     let (_,mp) = transform_sequent 1 m in print_relation mp;print_model mp
| Success pr -> let (_,np) = transform_proof 1 pr in print_string "Proof\n";print_proof np
;;







(* Tout est prêt pour l'impression des modèles dans structure.ml
avec les fonctions suivantes :
1) transform_sequent n a = p, ap  
n est le premier entier disponible comme état
a est de type sequent_model (dont les états sont les séquents critiques)
p est l'entier suivant le dernier entier utilisé pour le modèle a
ap esr la transformation de a obtenue en remplaçant les états séquents critiques par des entiers
2) print_relation a
affiche le modèle a de type model, dont les états sont des entiers

*)
