open Format;;
open Model;;

(* affichage d'une formule *)

let print_formula a = 
  let rec prec_formula a =
	match a with
	  | False -> print_string "F"
	  | (Var x) -> print_string x
	  | (Abrev x) -> print_string x
	  | (Not a) -> print_string "-"; prec_formula a
	  | (Nec a) -> print_string "[]";  prec_formula a
	  | (Pos a) -> print_string "<>"; prec_formula a
	  | (And (a,b)) -> print_char '(';
	      prec_formula a; print_space () ;print_string ".";
	      print_space (); prec_formula b;
	      print_char ')'
	  | (Or (a,b)) ->  print_char '(';
	      prec_formula a; print_space (); print_string "+";
	      print_space(); prec_formula b;
	      print_char ')'
	  | (Imp (a,b)) ->  print_char '(';
	      prec_formula a;  print_space (); print_string "=>";
	      print_space (); prec_formula b;
	      print_char ')'
	  | (Equ (a,b)) ->  print_char '(';
	      prec_formula a;  print_space (); print_string "<=>";
	      print_space (); prec_formula b;
	      print_char ')'

  in 
    (open_hvbox 2; prec_formula a ; close_box (); print_flush());;


