%{open Structure
%}


/* tokens for formula */
%token LPAR RPAR
%token AND OR NOT IMP EQU NEC POS FALSE
%token <string> VAR
%token END

/* priority */
%left EQU
%right IMP
%left OR
%left AND
%nonassoc NOT NEC POS
%start formula_alone
%type <Structure.formula> formula_alone

%%

formula :
  | VAR 				{Var $1}
  | FALSE                       {False}
  | LPAR formula RPAR		{$2}
  | NOT formula			{Not $2}
  | NEC formula			{Nec $2}
  | POS formula			{Pos $2}
  | formula AND formula		{And ($1,$3)}
  | formula OR formula		{Or ($1,$3)}
  | formula IMP formula		{Imp ($1,$3)}
  | formula EQU formula		{Equ ($1,$3)}
;

formula_alone :
  | formula END                 {$1}
;



