(* Complements pour les listes *)
open List ;;

let rec delete x l = 
   (* supprime tous les x de la liste l *)
   match l with
    [] -> []
    | a::fl -> if x = a then delete x fl else a::delete x fl;;

let rec suppress_multi_occurrence l =
    (* remplace les occurrences multiples d'éléments de l par une seule occurrence *)
   match l with
    [] -> []
    | a::fl -> if mem a fl then a::suppress_multi_occurrence (delete a fl)
               else a::suppress_multi_occurrence fl;;
