


let read_formula buffer = 
  (* lecture d'une formule (suivie de deux point-virgules) dans buffer *)
  Parser.formula_alone  Lexer.terminal buffer;;

let preuve cf = 
  (* cf est le nom d'un fichier contenant une formule 
     suivie de deux points-virgules
     preuve cf affiche 
     - la preuve de la formule si elle est valide
     - un contre modèle si elle n'est pas valide 
  *)
  let buffer = Lexing.from_channel (open_in cf) in
    try
      let a = (read_formula buffer) in
	(
	  print_string "result.";print_newline ();
	  Prouveur.try_proof_formula a;
	)
    with (* filtage des erreurs dans la formule *)
      | Lexer.Lexical_error | Parsing.Parse_error ->
	  print_string "error.";print_newline ();
	  print_string "The formula is incorrect line ";
	  let p = Lexing.lexeme_start_p buffer in 
	    (print_int p.Lexing.pos_lnum;
	     print_string " character ";
	     print_int (1+p.Lexing.pos_cnum - p.Lexing.pos_bol));
	    print_newline ()
;;


preuve Sys.argv.(1);;


