(* =============================================================================
================ FONCTIONS GENERALES SUR LES LISTES ============================
===============================================================================*)


let suppression p l =  
  (* résultat : la liste l privée des éléments qui vérifient la propriété p *)
  List.rev (List.fold_left (fun l1 x -> if p x then l1 else x::l1) [] l);;

let enlever x l = 
  (* résultat : la liste l privée des occurrences de x *)
  suppression (fun y -> x = y) l;;

let rec disjoint l1 l2 = 
  (* résultat : true ssi les 2 listes n'ont pas d'éléments commun *)
  match l1 with
    | [] -> true
    | dl1::fl1 -> not (List.mem dl1 l2) && (disjoint fl1 l2);;

 

let rec ens_de_liste l = 
  (* résultat : la liste l avec suppression de ses éléments répétés  *)
  match l with
    | [] -> []
    | t::f -> if List.mem t f then ens_de_liste f else t::(ens_de_liste f);;


let red infe x l1 =
  (* red infe  x l1 = (a, l2) où
   a vaut true si et seulement si l1 comporte un élément strictement inférieur à x 
   l2 est la liste obtenue en enlevant de l1 les éléments supérieurs ou égaux à x *)
  let rec aux = function
    | [] -> (false, [])
    | y::l2 -> let (a,l3) = aux l2 in 
      if (infe x y) then (a, l3) else if (infe y x) then (true,y::l3) else (a,y::l3)
  in aux l1;;
      

let reduction infe l1 =
(* calcule la liste des éléments x (minimaux) de l1 pour lesquels
   il n'y a pas de y, différent de x, dans l1 tel que (infe y x)
   Cela n'a aucun sens quand infe est total
   *)
  let rec aux = function
    | [] -> []
    | x::l2 -> let (a, l3) = red infe x l2 in
      if a then aux l3 else x::aux l3
  in aux l1;;


let rec sous_ens e =
  (* liste des sous-ensembles de la liste e *)
  match e with
    | [] -> [[]]
    | t::f -> let sef = sous_ens f in
	(List.map (fun x -> t::x) sef)@ sef;;

let sous_ens2 e =
  (* liste des sous-ensembles de e ayant au moins deux éléments *)
  suppression (fun x -> List.length x < 2) (sous_ens e);;


(* FIN FONCTIONS GENERALES LISTES *)
