type term = 
  | Var of string
  | Comp of string * term list;;

type literal = 
  | Pos of term 
  | Neg of term;;

(* Possible seulement après Ocaml 4.03 
type ab_literal =
  | A of {lit : literal; mutable scope : int}
  | B of literal;;
*)


type literal_scope = {lit :literal; mutable scope : int}
      
type ab_literal =
   | A of literal_scope
   | B of literal;;



type substitution = (string*term) list;;


(* Une preuve est aussi appelée une dérivation avec 3 règles, expansion, réduction, enlèvement*)

type proof_step = { chain : ab_literal list; proof : justification}
and
      justification =
  | Hyp
  | Reduce of int*substitution
	(* Reduce (i,s) reduction par le i-ème A litteral via la substitution s *)
  | Expand of int*ab_literal list*substitution
	(* Expand (i,c,s) expansion avec c par la substitution s où c copie d'une hypothèse  *)
  | Remove 
        (* Reduction du A littéral à gauche *)




    

