open Listc;;
open Types;;


(* ====================================================================================
 ======== SUBSOMPTION ENTRE CLAUSES (1° ordre) =========================================
 ======================================================================================= *)

(* ================================== SUBSTITUTION (1° ordre) ========================= *)

(* Une substitution est une liste de paires string * terme 
   Une équation est un couple de termes ou de littéraux *)

let subst_terme x t e =
  (* remplace (Var x) par le terme t dans le terme e *)
  let rec subst = function
    |((Var y) as u) -> if x = y then t else u
    | (Comp (y,ly)) -> Comp (y, List.map subst ly)
  in subst e;;

let subst_eqs x t le = 
  (* remplace (Var x) par t dans toutes les équations entre termes de la liste le *) 
  List.map (fun (u,v) ->(subst_terme x t u),(subst_terme x t v)) le;;

let subst_res x t lr = 
  (* remplace (Var x) par t dans les termes de la substitution lr *)
  List.map (fun (u,v) -> u, (subst_terme x t v)) lr ;;

let subst_t s t =
  (* applique la substitution s au terme t *)
  let rec subst_t_aux = function
    |((Var x) as y) -> (try (List.assoc x s) with Not_found -> y)
    | (Comp(x,lx)) -> Comp(x, List.map subst_t_aux lx)
  in subst_t_aux t;;
	
let subst_l s x =
  (* applique la substitution s au littéral x de type literal *)
  match x with
    | (Pos y) -> (Pos (subst_t s y))
    | (Neg y) -> (Neg (subst_t s y)) ;;

let subst_l_ab s x =
  (* applique la substitution s au littéral x de type ab_literal *)
  match x with
  | A {lit=y;scope=n} -> A {lit=(subst_l s y);scope=n}
  | B y -> B (subst_l s y) ;;





(* ================================= FIN SUBSTITUTION ==================================== *)


(* ===================================== FILTRAGE (1° ordre) ========================== *)

exception Echec_filtre ;;

let rec filtre_aux s u v =
  (* s est une substitution, u et v sont des termes, 
     résultat : une substitution s' extension de s tel que s'(u) = v 
     lève l'exception Echec_filtre si cette substitution  n'existe pas *)
  match u with
    | Var x -> (try if List.assoc x s = v then s else raise Echec_filtre
		with Not_found -> (x,v)::s)
    | Comp (f,lf) -> (match v with
		       | Var _ -> raise Echec_filtre
		       | Comp (g,lg) -> if f = g then filtre_aux_liste s lf lg else raise Echec_filtre)
and filtre_aux_liste s lf lg =
  match lf,lg with
      [],[] -> s
    | tf::ff, tg::fg -> filtre_aux_liste (filtre_aux s tf tg) ff fg
    | _ -> raise Echec_filtre;;

let filtre_termes t1 t2 =
  (* t1 et t2 sont des termes
     résultat : une substitution s telle que s(t1) = t2 
     lève l'exception Echec_filtre si cette substitution n'existe pas *)
  filtre_aux [] t1 t2;;

let filtre_litteraux l1 l2 =
  (* l1 et l2 sont des littéraux, de type literal
     résultat : une substitution s telle que s(l1) = l2 
     lève l'exception Echec_filtre si cette subsitution n'existe pas *)
  match l1,l2 with
    | Pos t1, Pos t2 -> filtre_termes t1 t2
    | Neg t1, Neg t2 -> filtre_termes t1 t2
    | _ -> raise Echec_filtre;;


let filtre_litteraux_ab l1 l2 =
  (* l1 et l2 sont de type ab_literal et doivent être des B-littéraux
     résultat : une substitution s telle que s(l1)=l2
     lève l'exception Echec_filtre si cette substitution n'existe pas *)
  match l1,l2 with
  | B m1, B m2 -> filtre_litteraux m1 m2
  | _ -> raise Echec_filtre;;



(* =======================================  FIN FILTRAGE ============================ *)

let rec geler_terme t = 
  (* t est un terme
     résultat : le terme dans lequel toute variable (Var x) est remplacée par la constante (Comp (x,[]))
  *)
  match t with
    | Var x -> Comp (x,[])
    | Comp(f,lt) -> Comp(f,List.map geler_terme lt);;

let geler_litteral l = 
  (* l est un littéral de type literal
     résultat : le littéral dans lequel toute variable (Var x) est remplacée par la constante (Comp (x,[]))
  *)
  match l with
  | Pos t -> Pos (geler_terme t)
  | Neg t -> Neg (geler_terme t)
  ;;

let geler_litteral_ab l =
  (* l est de type ab_literal
     résultat : comme ci-dessus de type ab_literal*)
  match l with
  | A {lit=m;scope=n} -> A {lit= geler_litteral m; scope=n}
  | B m -> B (geler_litteral m)
  ;;
  
let rec filtre c1 c2 =
  (* c1 et c2 sont des listes de littéraux de type ab_literal, c2 n'a pas de variable
  résultat : true si et seulement si il y a une substitution s telle que s(c1) est inclus dans c2*)
  match c1 with
    | [] -> true
    | t ::f -> List.exists 
	  (function l -> 
	    try let s = filtre_litteraux_ab t l in filtre (List.map (subst_l_ab s) f) c2
            with Echec_filtre -> false)
	c2;;

let inclus_clauses c1 c2 =
  (* résultat : true si et seulement la clause c1 subsume la clause  c2, 
     autrement dit s'il existe une substitution s telle que s(c1) est inclus dans c2 *)
  filtre c1 (List.map geler_litteral_ab c2);;

let rec is_subsumed c g =
  (* résultat : true si et seulement si une clause de la liste g de clauses subsume c *)
  match g with
  | [] -> false
  | d::fg -> inclus_clauses d c || is_subsumed c fg;;

(* =========================== FIN SUBSOMPTION ============================================== *)


(* =========================== REDUCTION ==================================================== *)

(* suppression des clauses valides *)

(* oppose, oppose_ab, oppose_ab_with_scope existe aussi dans rules.ml *)

let oppose l =
  (* l est un litteral *)
  match l with
  | Pos m -> Neg m
  | Neg m -> Pos m
	
let oppose_ab l =
  (* l est un ab littéral, le résultat est le ab littéral opposé *)
  match l with
  | A {lit = l; scope=n} -> A {lit= oppose l; scope=n}
  | B l -> B (oppose l)


let rec valide e = 
  (* résultat : true ssi e est une liste valide de littéraux *)
  match e with
   | [] -> false 
   | t::f -> (List.mem (oppose_ab t) f) || valide f;;


let suppression_valides  l = 
  (* enlève de l les clauses  valides *)
  suppression valide l;;

let elimination_inclusion_clauses e = reduction inclus_clauses e;;

let reduction e = elimination_inclusion_clauses (suppression_valides (ens_de_liste e)) ;;


