open Types;;
open Listc;;
open Affichage_preuves;;





(* ================================== SUBSTITUTION (1° ordre) ========================= *)

(* Une substitution est une liste de paires string * term 
   Une équation est un couple de termes ou de littéraux *)

let subst_terme x t e =
  (* remplace (Var x) par le terme t dans le terme e *)
  let rec subst = function
    |((Var y) as u) -> if x = y then t else u
    | (Comp (y,ly)) -> Comp (y, List.map subst ly)
  in subst e;;

let subst_eqs x t le = 
  (* remplace (Var x) par t dans toutes les équations entre termes de la liste le *) 
  List.map (fun (u,v) ->(subst_terme x t u),(subst_terme x t v)) le;;

let subst_res x t lr = 
  (* remplace (Var x) par t dans les termes de la substitution lr *)
  List.map (fun (u,v) -> u, (subst_terme x t v)) lr ;;

let subst_t s t =
  (* applique la substitution s au terme t *)
  let rec subst_t_aux = function
    |((Var x) as y) -> (try (List.assoc x s) with Not_found -> y)
    | (Comp(x,lx)) -> Comp(x, List.map subst_t_aux lx)
  in subst_t_aux t;;
	
let subst_l s x =
  (* applique la substitution s au littéral x de type literal *)
  match x with
    | (Pos x) -> (Pos (subst_t s x))
    | (Neg x) -> (Neg (subst_t s x)) 

let subst_l_ab s x =
  (* applique la substitution s au littéral x de type ab_literal *)
  match x with
  | A {lit=y;scope=n} -> A {lit=(subst_l s y);scope=n}
  | B y -> B (subst_l s y)


let subst_c s u =
  (* applique la substitution s à la chaîne u de littéraux de type ab_literal *)
  let rec aux u = match u with
  | [] -> []
  | x::fu -> (subst_l_ab s x)::aux fu
  in aux u;;
 				     
  

(* ================================= FIN SUBSTITUTION ==================================== *)
			

(* ================================== UNIFICATION (1° ordre) ============================= *)

exception Not_unifiable;;

let occur v t = 
  (* lève l'exception Not_unifiable si v est une variable du terme t *)
  let rec aux = function
    | (Var v') -> if v = v' then raise Not_unifiable
    | (Comp (_,la)) -> List.iter aux la
  in aux t;;	

let rec trans e  s  = 
  (* calcule par une méthode assez lente l'instance principale s' de la substitution s 
     où s' est solution du système e d'équations entre termes 
     si s' n'existe pas, l'exception Non_unifiable est levée *)
match e with
| [] -> s
| (t1,t2)::le ->
    if t1 = t2 then trans le s
    else
      match (t1,t2) with
	| (Var x,  t) -> occur x t; 
	    trans (subst_eqs x t le) (let sp =(subst_res x t s)
	    in if List.mem (x,t) sp then sp else (x,t)::sp) 
	| (t, Var x) -> occur x t; 
	    trans (subst_eqs x t le) (let sp =(subst_res x t s)
	    in if List.mem (x,t) sp then sp else (x,t)::sp)
	|  (Comp(x,lx),Comp(y,ly)) -> 
	     if x = y && (List.length lx) = (List.length ly)
	     then (trans ((List.combine lx ly) @ le)  s) 
	     else raise Not_unifiable
;;	
	

let unift t1 t2 = 
  (* si les termes t1 et t2 sont unifiables, cette fonction en
     calcule l'unificateur principal, sinon elle lève l'exception Not_unifiable *)
  trans [t1,t2] [];;	

let rec equations_de_liste l =
  (* transforme la liste [x1; x2; x3; ...] en une liste de couples [x1,x2; x2,x3; ...]*)
  match l with
    | [] -> []
    | [_] -> []
    | x1::x2::f -> (x1,x2)::equations_de_liste (x2::f);;

let equation_de_termes_de_equations_de_litterals e =
  (* change une équation entre littérals en une équation entre termes
     lève l'exception Non_unifiable s'il n'y a pas de solution *)
  match e with
    | Pos t1, Pos t2 -> t1,t2
    | Neg t1, Neg t2 -> t1,t2
    | _ -> raise Not_unifiable;;

let unifl l =
  (* si la liste l de littéraux est unifiable, en calcule l'unificateur principal
     sinon lève l'exception Non_unifiable *)
  let l1 = equations_de_liste l in
  let l2 = List.map equation_de_termes_de_equations_de_litterals l1 in
    trans l2 [];;

(* ============================== FIN UNIFICATION ========================================== *)






    
(* ============================ RENOMMAGE D'UNE CLAUSE (1° ordre) ========================== *)

let nv l =
  (* produit une chaîne "v{chiffre}" non élément de la liste l *)
  let rec aux i = let s = "v"^(string_of_int i) in 
    if (List.mem s l) then aux (i+1) else s
  in aux 0;;



let rec renommage e f =
  (* e est une liste de chaînes sans répétition,
     la fonction calcule un renommage de domaine e par des variables hors de f.
     Si t variable de e est aussi dans f, elle doit être renommée.
     (t, Var x) est un renommage car x qui renomme t, n'est pas élément de f et pas élément de e.
     La fin est renommée hors de x et de f, donc la combinaison de ces deux renommage est un
     renommage de e hors de f.
   *)
  match e with
    | [] -> []
    | t::fin ->
	if List.mem t f
	then let x= nv (e@f) in (t, Var x)::(renommage fin (x::f))
	else renommage  fin f
  
 
let rec vars_terme t =
  (* liste des variables du terme t *)
  match t with
    | Var x -> [x]
    | Comp(_,l) -> List.fold_left (fun a b -> a @ (vars_terme b)   ) [] l;;

let vars_literal l =
  (* liste des variables du littéral l *)
  match l with
    | Pos t -> vars_terme t
    | Neg t -> vars_terme t;;

let vars_literals c =
  (* liste sans répétition des variables de la liste c de litteraux *)
  ens_de_liste (List.fold_left (fun a b -> a @ (vars_literal b)   ) [] c);;

let vars_ab_literal l =
  (* liste des variables du ab_litteral l*)
  match l with
  | A {lit=t;scope=_} -> vars_literal t
  | B t -> vars_literal t;;



let vars_ab_literals c =
  (* liste sans repetition des variables de la liste c de ab_litteraux *)
  ens_de_liste (List.fold_left (fun a b -> a @ (vars_ab_literal b)   ) [] c);;



(* ============================== FIN RENOMMAGE ===================================== *)

(* ============================== REDUCTION ========================================= *)

let unif_ba_literals l m =
  (* l est un B litteral et m un A ou B litteral
     Si m est un A littéral  et si l'opposé de m est unifiable à l alors le résultat est la substitution 
     les unifiant, sinon l'exception Not_unifiable est levée
  *)
  match l, m with
  | B (Pos l'), A {lit=(Neg m');scope=_} -> unift l' m'
  | B (Neg l'), A {lit=(Pos m');scope=_} -> unift l' m'
  | _ -> raise Not_unifiable

  
let unif_bb_literals l m =
   (* l et m sont des B littéraux unifiables, le résultat est la substitution des unifiants,
      sinon l'exception Not_unifiable est levée 
    *)
  match l, m with
  | B (Pos l'),B (Pos m') -> unift l' m'
  | B (Neg l'),B (Neg m') -> unift l' m'
  | _ -> raise Not_unifiable



let rec nb_anc u =
  (* u liste de ab_literal
     résultat nombre de littéraux ancêtres de cette chaine *)
  match u with
  |[] -> 0
  |A _::fu -> 1+nb_anc fu
  |B _::fu -> nb_anc fu
;;


let reductions l u =
  (* l ab_literal, u liste de ab_literal 
     On calcule les successeurs de la chaine lu  par réduction. Soit u = v[m]w, 
     S'il existe une substitution s unifiant -l et m
     alors 
     s(u) est obtenue par réduction de lu 
     Reduce (i,s) où i est la longueur de v, est la justification de ce pas
     La fonction délivre l'ensemble de ces réductions
   *)
  let rec aux n du fu =
    match fu with
    | [] -> []
    | (B m)::w -> aux (n+1) (du@[B m]) w	  
    | (A m)::w ->
	(try
	  let s = unif_ba_literals l (A m) in
	  let na= nb_anc du in
	  (if na > m.scope then m.scope <- na;
	  [{chain = subst_c s u; proof = Reduce (n,s)}])
	 with
	  Not_unifiable -> []) @ aux (n+1) (du@[A m]) w
  in aux 2 [] u;;



	
    

(* ============================= FIN REDUCTION ===================================== *)




(* ============================== EXPANSION ========================================= *)


let oppose l =
  (* l est un litteral *)
  match l with
  | Pos m -> Neg m
  | Neg m -> Pos m
	
let oppose_ab l =
  (* l est un ab littéral, le résultat est le ab littéral opposé *)
  match l with
  | A {lit=l;scope=p} -> A {lit=oppose l;scope=p}
  | B l -> B (oppose l)



let change_b_to_a l =
  (* l est un b littéral, qui est changé en a *)
  match l with
  | B m -> A {lit=m;scope=0}
  | _ -> failwith "Is not a B-literal"




let expansion_without_copy l u c =
  (* On suppose c sans variable commune avec lu
     Pour tout vmw tel que c=vmw, m étant un litteral, si
     l et l'opposé de m ont un unificateur s, alors
     on ajoute l'expansion s(vw[l]u) avec la justification Expand(i,c,s)
     où i est 1+longueur de v
   *)
  let rec aux v mw =
    match mw with
    | [] -> []
    | m :: w ->
	(try
	  let s= unif_bb_literals l (oppose_ab m) in 
	  [{chain = subst_c s (v@w@[change_b_to_a l]@u);
	    proof = Expand (1+List.length v,c,s)}]
	with Not_unifiable -> [])@aux (v@[m])w	  
  in  aux [] c;;

let expansion l u c =
  (* On fait un renommage de c avec des variables qui ne sont ni des variables de lu 
     ni des variables de c puis on fait l'expansion sans copie avec la copie de c
   *)
  let vlu = vars_ab_literals (l::u) and vc = vars_ab_literals c in
  let s = renommage vc (vc@vlu)
  in expansion_without_copy l u (subst_c s c);;
  

let expansions l u g =
  (* l B-littéral, u chaîne de A et B littéraux
     On calcule les successeurs de la chaine l::u par expansion avec les clauses
     de g. 
   *)
  let rec aux g = 
    match g with
    | [] -> []
    | c::fg -> (expansion l u c)@aux  fg
  in aux g;;


(* ============================= CONSTRUCTION DES PREUVES ============================ *)




let rec clauses_vers_pas lc =
  (* lc est une liste de chaines, le résultat est la liste de pas {chain=c;proof=Hyp} où
     c est un élément de lc
   *)
   match lc with
   |[] -> []
   |c::flc -> {chain=c;proof=Hyp}::clauses_vers_pas flc ;;

let ens_lemmes = ref [];;

let rec gen_lemme n c =
  (* lemme engendré par c avec n littéraux ancêtres à gauche de c
     Attention : le lemme vide est une conjonction fausse donc une disjonction vraie qui ne doit pas être ajoutée
     voir dans preuve Génération des lemmes
   *)
  match c with
  |[] -> []
  |(B _)::fc -> gen_lemme n fc
  |(A l)::fc -> if l.scope = n then (if l.scope > 0 then l.scope <- l.scope-1; B (oppose l.lit)::gen_lemme (n+1) fc)
  else gen_lemme (n+1) fc;;

   
let preuves_completes n g =
  (* données : n entier, g liste de chaines
     résultat : (a,p) a = true ssi il y a une dérivation p de longueur au plus n
     de la clause vide commençant par une chaine de g, les expansions étant effectuées avec des éléments de g
   *)
   
   let rec preuve n c =
   (* données : n entier, g liste de chaines, c une chaine non vide
      résultat : (a,p) a true ssi il y a une dérivation p de longueur au plus n
      de la clause vide commençant pas la chaîne c, les expansions étant effectuées avec des éléments de g
    *)
     if n = 0 then (false,[])
	 else
       match c with
       | [] -> (true,[])
       | (A _) ::u ->
	   let (a,q) = preuve (n-1) u in
	   (  (* Génération des lemmes *)
	      let lemme = gen_lemme 0 c in
	      if (lemme <> []) && not (Subsomption.is_subsumed lemme g) then
		ens_lemmes := lemme::(!ens_lemmes);
	      (a, {chain=u;proof=Remove}::q))
       | (B _) as l::u ->
	   let er = (reductions l u) @ (expansions l u g) in
	   preuves (n-1) er 	     
   and
       preuves n er =
     (
      if n > 0 then
	match er with
	| [] -> (false,[])
	| s::fer -> let (a,q) = preuve n s.chain  in (if a then (true,s::q) else (preuves n fer))
      else (false,[]))
  in  let sg = clauses_vers_pas g in preuves n sg  ;;



   
