open Rules;;
open Arg;;

let start = ref 0.0 ;;

let print_time () = print_string "Proof duration (in seconds): ";
  print_float (Unix.gettimeofday() -. !start); print_newline ();;

(* Soit n un entier et e une liste de chaines de B-litteraux (me_prouveur n e) 
  recherche s'il y a une preuve de [] dérivable de e et affiche cette preuve *)


let rec me_prover_with_lemma n e =
  (* la tentative de preuve est répétée deux fois. Les lemmes produits par le premier essai et
     non subsumés par les hypothèses sont ajoutés aux hypothèses pour le deuxième essai *)
  let (a,p) = Rules.preuves_completes n e in
  if a then
    Affichage_preuves.print_preuve  p 1
  else
    ( print_string "generated lemmas used in second attempt to prove :\n";
      Affichage_preuves.print_list_ab_literals (Subsomption.reduction !ens_lemmes);
      print_newline ();
      let (a,p) = Rules.preuves_completes n (e @ !ens_lemmes)  in
      if a then
	Affichage_preuves.print_preuve p 1
      else
	print_string "Proof not found\n"
     );;





(* Appel du prouveur avec contrôle du temps *)

(* ================== CONTROLE DU TEMPS D'EXECUTION ================= *)



let delay = ref 10 ;;

let file = ref "" ;;

let max_pr = ref 15 ;;

exception Too_long ;;

let clock = Sys.Signal_handle (function _ -> raise Too_long) ;;



let me_prouveur_borne n e  =
  (* n est la longueur maximum de preuves, e est la liste des chaines
     dont on veut dériver la clause vide, 
     une chaine est de type ab_literal list
   *)
  try 
    (Sys.set_signal Sys.sigalrm clock; let _ = Unix.alarm !delay in ();
    start := Unix.gettimeofday();
    me_prover_with_lemma n  (Subsomption.reduction e);
    (* affichage des lemmes engendrés
    print_string "generated lemmas:\n";
    Affichage_preuves.print_list_ab_literals_with_scope (Subsomption.reduction !ens_lemmes);
    print_newline ();
    fin affichage des lemmes engendrés *)
    print_time();
    Sys.set_signal Sys.sigalrm Sys.Signal_ignore; ())
  with 
    Too_long ->
      ((* affichage des lemmes engendrés
	 print_string "generated lemmas:\n";
	 Affichage_preuves.print_list_ab_literals_with_scope (Subsomption.reduction !ens_lemmes);
       print_newline ();
       fin affichage des lemmes engendrés *)
       Sys.set_signal Sys.sigalrm Sys.Signal_ignore;
       print_string "interrupted proof (more than ";
       print_int !delay;print_string " seconds)\n");;

(* ======================= FIN CONTROLE DU TEMPS D'EXECUTION =================== *)   


(* ======================= LECTURE DES CLAUSES ET APPEL PRINCIPAL ============== *)

let lire_clauses buffer =
  Parser.clauses_fin Lexer.terminal buffer;;

let me_prouveur_simple () =
  let parameters =
    ["-s",Set_string file, "f, f is a string, name of the file containing the
       clauses, from whose we try to derive the empty clause";
  "-t",Set_int delay,"s, s is an integer, maximum duration to find a proof";
"-l",Set_int max_pr, "n, n is an integer, maximum length of a proof"] in
  Arg.parse parameters (fun x -> ()) "";
  let buffer =  Lexing.from_channel (open_in (!file)) in
  try
    (let lc = lire_clauses buffer in
    print_string "result.\n"; ens_lemmes:=[]; me_prouveur_borne (!max_pr) lc )
  with (* filtrage des erreurs lexicales et syntaxiques *)
  | Lexer.Erreur_lexicale | Parsing.Parse_error ->
      print_string "error.\n";
      print_string "la liste de clauses est incorrecte ligne ";
      let p = Lexing.lexeme_start_p buffer in
      (print_int p.Lexing.pos_lnum;
       print_string " caractère ";
       print_int (1+p.Lexing.pos_cnum - p.Lexing.pos_bol));
      print_newline ();;

me_prouveur_simple ();;
