(* =============================================================================
================ FONCTIONS GENERALES SUR LES LISTES ============================
===============================================================================*)


let suppression p l =  
  (* résultat : la liste l privée des éléments qui vérifient la propriété p *)
  List.rev (List.fold_left (fun l1 x -> if p x then l1 else x::l1) [] l);;

let enlever x l = 
  (* résultat : la liste l privée des occurrences de x *)
  suppression (fun y -> x = y) l;;

let rec disjoint l1 l2 = 
  (* résultat : true ssi les 2 listes n'ont pas d'éléments commun *)
  match l1 with
    | [] -> true
    | dl1::fl1 -> not (List.mem dl1 l2) && (disjoint fl1 l2);;

 

let rec ens_de_liste l = 
  (* résultat : la liste l avec suppression de ses éléments répétés  *)
  match l with
    | [] -> []
    | t::f -> if List.mem t f then ens_de_liste f else t::(ens_de_liste f);;



let inf_elt r x l =
  (* true ssi il y a dans l un élément y tel que (r y x) = true*)
  let rec aux = function
    | [] -> false
    | y:: m -> if r y x then true else aux m
  in aux l;;

let red r x l =
  (* résultat  la liste l dont on enlève les éléments y tels que (r x y) = true *)
  let rec aux = function
    | [] -> []
    | y::m -> if r x y then aux m else y::aux m
  in aux l;;

let reduction r l =
  (* x, élément de la liste l, est minimal ssi il n'y a pas un autre élément y de cette  liste tel que 
     (r y x) = true
     a est minimal dans la liste x::m ssi on est dans un des deux cas suivants
     (1) x n'est pas minimal, dans cette liste car (inf_elt r x m)=true, et a minimal dans m
     (2) x est minimal, et a est minimal dans la liste obtenue en enlevant de m les éléments tels que (r x y)=true
     D'où le programme ci-dessous de calcul des éléments minimaux de l 
   *)
  let rec aux = function
    | [] -> []
    | x::m -> if inf_elt r x m then aux m else x::aux (red r x m)
  in aux l;;

let rec sous_ens e =
  (* liste des sous-ensembles de la liste e *)
  match e with
    | [] -> [[]]
    | t::f -> let sef = sous_ens f in
	(List.map (fun x -> t::x) sef)@ sef;;

let sous_ens2 e =
  (* liste des sous-ensembles de e ayant au moins deux éléments *)
  suppression (fun x -> List.length x < 2) (sous_ens e);;


(* FIN FONCTIONS GENERALES LISTES *)
