<?php $title="Information";include("header.inc"); ?>

The theoretical basis of this <em>Model Elimination</em> prover is described here in
<a href="me-english.pdf">english</a> and
in <a href="me-français.pdf">french</a>.<br>

A <em>chain</em> is list of A-literal and B-literal. A B-literal is a literal in the usual sense.
A A-literal, also called literal ancestor,  is a literal beetween brackets followed by an integer,
the scope of the litteral.
Here is an example of a chain : p(x) [q(x,y)]<sup>0</sup> r(z) [-q(a,b)]<sup>1</sup>.
The scope of the first ancestor literal is 0 and the scope of
the second ancestor literal is 1.
<br>
Let &Gamma; be a list of clauses. A <em>derivation</em> from &Gamma; is a list of chains
C<sub>i</sub> (i from 1 to n) such that
C<sub>1</sub> is element of &Gamma; and C<sub>i+1</sub> (i from 1 to n-1)  is obtained from
C<sub>i</sub> by one of the rules,
extension with a element of &Gamma;, reduction and removal.
<br>
<ul>
	<li> Extension from &Gamma;:
	Let LU be a chain beginning with the B-literal L. Let VMW a copy of an element of &Gamma;
	where M is a literal and whose
	variables do not appear in LU. Let us suppose that there exists a most general unifier &sigma;
	unifying L and the opposite
	of  M. The chain &sigma;(VW[L]<sup>0</sup>U) is obtained by extension of LU from &Gamma;.<br>
	The initial scope of the new literal ancestor is 0.
	<li> Reduction :
	Let LU[M]V a chain, where L is a literal and [M] an ancestor literal.
	Let us suppose that there exists a most general
	unifier &sigma; unifying L and the opposite of M.
	The chain &sigma;(U[M]V) is obtained by reduction of LU[M]V.<br>
	The scope of [M] becomes the maximum of its scope before the
	reduction and the number of literal ancestors of U.
	<li>Removal :
	Let [L]U be a chain benginning with the literal ancestor [L].
	The chain U is obtained by removal on [L]U.<br>
	Let D the disjunction of the opposite of all the literal ancestors of LU,
	whose scope is equal to the number of
	lteral ancestors to their left.
	This disjunction is a <em>lemma</em> deduced from &Gamma;. The scope from these literal ancestors
	is decremented.
</ul>
<br>
With the button <b>Max time of proof</b>, you can limit in seconds the time allocated to the prover.
With the button
<b>Max length of proof</b>, you can limit the length of the derivations explored by the prover.
<br>
Let n be the maximum length set for the derivations.
<br>
With the button <b>Prove Empty Clause without Lemma</b>, the prover explored once all the derivations of
length <em>at most n</em> and
stops when it discovers a derivation of the empty clause or when there is no derivation of the empty clause.
<br>
With the button <b>Prove Empty Clause with Lemma</b>, the prover explored  all the derivations of
length <em>at most n</em> and
stops when it discovers a derivation of the empty clause.
During this first research of a derivation of empty clause, the prover
collect all the lemmas not subsumed by the given clauses.
When this research is finished without discovering a derivation
of empty clause, the prover starts a <em>second</em> research of such a derivation,
from the given clauses and <em>from the lemmas added during the first research</em>.
<br>
The prover is complete, that means, if the list of clauses is unsatisfiable and
if there is no limit of time and length of
derivation, it will find a derivation of  the empty clause.  

<?php include("footer.inc"); ?>
