open Types

(* ================== AFFICHAGE DES PREUVES ===================== *)
(* Une preuve est une liste de proof_step *)

let rec print_terme t =
  (* 1° ordre : impression du terme t*)
  match t with
    | Var x -> print_string x
    | Comp(f,l) -> print_string f; 
	if l <> [] 
	then (print_string "("; print_terme (List.hd l);
	      List.iter (fun t -> print_string ", "; print_terme t) (List.tl l);
	      print_string ")");;
      

let print_litteral l  = 
  (* impression du littéral l *)
  match l with
  | Pos v -> print_terme v  
  | Neg v -> print_string "-"; print_terme v
;;

let print_ab_literal l  =
  match l with
  | A {lit=m;scope=n} -> print_string "[";print_litteral m;print_string "]^";print_int n
  | B m -> print_litteral m
;;



let print_ab_literals ll =
  (* impression d'une liste de AB-littéraux 
     La clause vide est notée F, les littéraux d'une chaine sont séparés par des espaces.
     Cette présentation peut être changée, par exemple par la forme normale d'une chaine
   *)
  if ll= [] then print_string "F "
  else
    (print_ab_literal (List.hd ll); 
     List.iter (fun l -> print_string " "; print_ab_literal l) (List.tl ll))
;;

let print_list_ab_literals l =
  (* affichage d'une liste de liste de ab_literal *)
  if l = [] then ()
  else
    (print_ab_literals (List.hd l);
     List.iter (fun l -> print_string ", "; print_ab_literals l) (List.tl l)) ;;


let print_substitution s =
  (* affiche une substitution s *)  
  match s with
  (x,t)::fs ->
    ( print_string "     "; print_string x; print_string " := ";print_terme t;
      List.iter (fun (x,t) -> print_string "; ";
	print_string x; print_string " := ";print_terme t; ) fs)
  | _ -> ()
  ;; 


(* Rappel un pas de preuve est {chain:ab_literal list;proof:justification}
   et le type jusfication est Hyp, Remove, Reduce (i,s), Expand (i,c,s) *)



(* Version de print_pas avec enlèvement *)

let print_pas p n =
  (* un pas p (numéroté n) est affiché suivi d'un retour à la ligne *)
  print_int n; print_string ": ";
  match p with
  | {chain=c;proof = Hyp} ->  print_ab_literals c; print_string "\n   Hypothesis\n"
  | {chain=c;proof = Remove} -> print_ab_literals c; print_string "\n   Remove\n"
  | {chain=c;proof = Reduce (i,s)} -> 
      print_ab_literals c; print_string "\n   Reduction of the literal ";
      print_int i;
      if s <> [] then (print_string "\n   by substitution "; print_substitution s);
      print_newline ()
  | {chain=c;proof = Expand (i,d,s)} -> 
      print_ab_literals c;
      print_string "\n   Expansion "; print_string "on literal ";print_int i;
      (* print_string "\n    Expansion on literal ";
	 print_int i; print_string " of hypothesis "; print_ab_literals d;*)
      print_string "\n   with hypothesis "; print_ab_literals d;
      if s <> [] then (print_string "\n   by  substitution "; print_substitution s);
      print_newline ()
;;




let rec print_preuve pr n =
  (* une preuve pr est affichée, les pas sont numérotés à partir de n *)
  match pr with
  |[] -> ()
  |s::fpr -> print_pas s n; print_preuve fpr (n+1)
;;


